unit Unit1;

{==============================================================================}
{ This demo shows how to read information about items in RichView              }
{ Key methods and properties:                                                  }
{ - ItemCount,                                                                 }
{ - GetItemStyle,                                                              }
{ - GetItemTextA, GetItemTags, GetBreakInfo, GetPictureInfo, GetControlInfo,   }
{   GetBulletInfo, GetHotspotInfo                                              }
{ This demo also shows "hotspots"                                              }
{==============================================================================}

interface

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  StdCtrls, RVScroll, RichView, RVStyle, SclRView, SRVControl, SRVButton, RVTypes;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    Label1: TLabel;
    Label2: TLabel;
    ImageList1: TImageList;
    srv1: TSRichViewEdit;
    srv2: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure FillLeftRichView;
    procedure FillRightRichView;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{------------------------------------------------------------------------------}
procedure TForm1.FillLeftRichView;
var bmp: TBitmap;
    btn: TSRVButton;
begin
  with srv1.RichViewEdit do  begin
    AddNL('Reading information about items',1,1);

    AddBreakEx(2, rvbsLine, clRed);

    AddNL('Image: ',0,0);
    bmp := TBitmap.Create;
    bmp.Width  := 60;
    bmp.Height := 40;
    bmp.Canvas.Pen.Color := clRed;
    bmp.Canvas.Brush.Color := clYellow;
    bmp.Canvas.Rectangle(0,0,60,40);
    AddPictureEx('Yellow box', bmp, -1, rvvaMiddle);

    AddBreak;

    AddNL('Bullet: ',0,0);
    AddBulletEx('Printer image',0, ImageList1, -1);

    AddBreak;

    AddNL('Hotspot: ',0,0);
    AddHotspotEx('Active printer image',1, 0, ImageList1, -1);
    AddNL('(move mouse to hotspot and you see picture changes;'+
          ' more information about hotspots will be in hypertext description)',
          0,-1);

    AddBreak;

    AddNL('Button: ',0,0);
    btn := TSRVButton.Create(nil);
    btn.Width := 100;
    btn.Caption := 'Out of order';
    AddControlEx('Button example', btn, -1, rvvaBaseline);

    Format;
  end;
  srv1.RefreshData;
end;
{------------------------------------------------------------------------------}
function GetVAlignString(VAlign: TRVVAlign): String;
begin
  case VAlign of
    rvvaBaseline:
      Result := 'text base line';
    rvvaMiddle:
      Result := 'text middle';
    rvvaAbsTop:
      Result := 'line top';
    rvvaAbsBottom:
      Result := 'line bottom';
    rvvaAbsMiddle:
      Result := 'line middle';
    else
      Result := '?';
  end;
end;
{------------------------------------------------------------------------------}
procedure TForm1.FillRightRichView;
var
    i, ItemStyle: Integer;
    s: String;
    Tag: Integer;
    {.................................................................}
    procedure GetBreakInfo(ItemNo: Integer);
    var Width: Byte;
        Color: TColor;
        Style: TRVBreakStyle;
        Tag: Integer;
        ColorString: String;
    begin
      srv1.RichViewEdit.GetBreakInfo(ItemNo, Width, Style, Color, Tag);
      if Color = clNone then
        ColorString := 'line has color of the 0-th text style'
      else
        ColorString := ColorToString(Color);
      srv2.RichViewEdit.AddFmt('Item #%d: break. Color=%s; Width=%d',
        [ItemNo, ColorString, Integer(Width)], 0, 0);
      // Style is always rvbsLine in current version
    end;
    {.................................................................}
    procedure GetPictureInfo(ItemNo: Integer);
    var gr: TGraphic;
        VAlign: TRVValign;
        VAString: String;
        Name: TRVAnsiString;
        Tag: Integer;
    begin
      srv1.RichViewEdit.GetPictureInfo(ItemNo, Name, gr, VAlign, Tag);
      VAString := GetVAlignString(VAlign);
      srv2.RichViewEdit.AddFmt(
        'Item #%d: image (%s, %dx%d); Vertical alignment: %s; Name="%s"',
        [ItemNo, gr.ClassName, gr.Width, gr.Height, VAString, Name],
        0, 0);
    end;
    {.................................................................}
    procedure GetControlInfo(ItemNo: Integer);
    var ctrl: TControl;
        VAlign: TRVValign;
        VAString: String;
        Name: TRVAnsiString;
        Tag: Integer;
    begin
      srv1.RichViewEdit.GetControlInfo(ItemNo, Name, ctrl, VAlign, Tag);
      VAString := GetVAlignString(VAlign);
      srv2.RichViewEdit.AddFmt(
        'Item #%d: control (%s, %dx%d); Vertical alignment: %s; Name="%s"',
        [ItemNo, ctrl.ClassName, ctrl.Width, ctrl.Height, VAString, Name],
        0, 0);
    end;
    {.................................................................}
    procedure GetBulletInfo(ItemNo: Integer);
    var ImageList: TCustomImageList;
        Name: TRVAnsiString;
        ImageIndex, Tag: Integer;
    begin
      srv1.RichViewEdit.GetBulletInfo(ItemNo, Name, ImageIndex, ImageList, Tag);
      srv2.RichViewEdit.AddFmt(
        'Item #%d: bullet; ImageList="%s"; Image index=%d; Name="%s"',
        [ItemNo, ImageList.Name, ImageIndex, Name],
        0, 0);
    end;
    {.................................................................}
    procedure GetHotspotInfo(ItemNo: Integer);
    var ImageList: TCustomImageList;
        Name: TRVAnsiString;
        ImageIndex, HotImageIndex, Tag: Integer;
    begin
      srv1.RichViewEdit.GetHotspotInfo(ItemNo, Name, ImageIndex, HotImageIndex, ImageList, Tag);
      srv2.RichViewEdit.AddFmt(
        'Item #%d: bullet; ImageList="%s"; Image index=%d, Hot image index=%d; Name="%s"',
        [ItemNo, ImageList.Name, ImageIndex, HotImageIndex, Name],
        0, 0);
    end;
    {.................................................................}
begin

  // Reading information about items
  for i := 0 to srv1.RichViewEdit.ItemCount-1 do begin
    ItemStyle := srv1.RichViewEdit.GetItemStyle(i);
    if ItemStyle>=0 then begin
      // Parameter of GetItemStyle - index of item (0..ItemCount).
      // If GetItemStyle returns zero or positive value,
      // this item is a text, and returned value is an index in
      // collection of styles (RVStyle.TextStyles)
      s := srv1.RichViewEdit.GetItemTextA(i);
      Tag := srv1.RichViewEdit.GetItemTag(i);
      srv2.RichViewEdit.AddFmt('Item #%d: text. Value="%s". Style of text is "%s"',
        [i, s, RVStyle1.TextStyles[ItemStyle].StyleName],0,0);
      end
    else
      // If GetItemStyle returns negative value, this item is a non-text item
      case ItemStyle of
        rvsBreak:
          GetBreakInfo(i);
        rvsPicture:
          GetPictureInfo(i);
        rvsComponent:
          GetControlInfo(i);
        rvsBullet:
          GetBulletInfo(i);
        rvsHotspot:
          GetHotspotInfo(i);
        else
          srv2.RichViewEdit.AddNL('Unknown item type', 0, 0);
      end;
    srv2.RichViewEdit.AddBreak;
  end;
  srv2.RichViewEdit.Format;
  srv2.RefreshData;
end;
{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
  srv1.SetMargin(5, 5, 5, 5);
  srv2.SetMargin(5, 5, 5, 5);

  FillLeftRichView;
  FillRightRichView;
end;

end.
